/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.common.util;

import com.ibm.hsc.access.api.AcaUtils;
import com.ibm.hsc.cim.exceptions.HSCCIMCltException;
import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hsc.common.util.HscCimomListener;
import com.ibm.hsc.common.util.HscPasswordMgr;
import com.ibm.hsc.common.util.UserInfo;
import com.ibm.hsc.indication.client.HSCCltEventQueue;
import com.ibm.hsc.indication.client.HSCSubscriptionMgr;
import com.ibm.hsc.indication.client.HSCSubscriptionMgrFactory;
import com.ibm.websm.bridge.WRemoteSystem;
import com.ibm.websm.bridge.WSession;
import com.ibm.websm.bridge.WSessionMgr;
import com.ibm.websm.diagnostics.IDebug;
import com.ibm.websm.etc.EAuthorization;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import org.snia.wbem.cim.CIMClass;
import org.snia.wbem.cim.CIMDataType;
import org.snia.wbem.cim.CIMException;
import org.snia.wbem.cim.CIMInstance;
import org.snia.wbem.cim.CIMNameSpace;
import org.snia.wbem.cim.CIMObjectPath;
import org.snia.wbem.cim.CIMProperty;
import org.snia.wbem.cim.CIMValue;
import org.snia.wbem.cim.UnsignedInt16;
import org.snia.wbem.client.CIMClient;

public class HscUtil {
    public static final int HU_WEBSM_INIT = 1;
    public static final int HU_WEBSM = 2;
    public static final int HU_SINGLECMD = 3;
    public static final int HU_CMDCTRL = 4;
    public static final int HU_CCFW = 5;
    protected static int s_utilOwner = 0;
    private static String s_uname = "unknownuser";
    private static String s_magickey = "NO_KEY_SET";
    public static final String KEY_SEPARATOR = "~";
    public static final String NAME_SPACE = "root/ibmhscS1_0";
    private static final CIMDataType _strArrayType;
    private static HSCSubscriptionMgr subscription;
    private static CIMClient _eventCimClient;
    private static boolean _debug;

    public static int initHscUtil(int n) {
        if (n >= 1 && n <= 5 && s_utilOwner == 0 || s_utilOwner == 1) {
            s_utilOwner = n;
            switch (s_utilOwner) {
                case 3: {
                    s_uname = System.getProperty("HMCRealUser.name");
                    if (s_uname == null) {
                        s_uname = AcaUtils.getUsername();
                    }
                    if ((s_magickey = AcaUtils.getPwdkeyByName((String)s_uname)) != null) break;
                    s_magickey = "NO_KEY_SET";
                    break;
                }
                case 5: {
                    if (AcaUtils.getUsername().equalsIgnoreCase("ccfw")) {
                        s_uname = HscPasswordMgr.getHscUser();
                        s_magickey = HscPasswordMgr.getCredentialKey(s_uname);
                        break;
                    }
                    s_magickey = "NO_KEY_SET";
                }
            }
        }
        return s_utilOwner;
    }

    public static Vector decodeKey(String string) {
        Vector<String> vector = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, KEY_SEPARATOR, false);
        if (stringTokenizer != null) {
            vector = new Vector<String>();
            while (stringTokenizer.hasMoreTokens()) {
                vector.addElement(stringTokenizer.nextToken());
            }
        }
        return vector;
    }

    public static CIMValue getCIMAttribute(String string, CIMObjectPath cIMObjectPath, String string2) throws CIMException {
        CIMClient cIMClient = HscUtil._getCIMClient(string);
        if (cIMClient != null) {
            try {
                CIMValue cIMValue;
                CIMValue cIMValue2 = cIMClient.getProperty(cIMObjectPath, string2);
                String string3 = cIMObjectPath.getObjectName();
                if (string2.equalsIgnoreCase("classCodeInfo") && string3.equalsIgnoreCase("IBMHSC_PCISlot")) {
                    cIMValue = cIMClient.getProperty(cIMObjectPath, "classCode");
                    cIMValue2 = HscUtil.handleSlotClassCode(cIMValue, cIMValue2);
                }
                cIMValue = cIMValue2;
                return cIMValue;
            }
            catch (CIMException cIMException) {
                throw new HSCCIMCltException(cIMException);
            }
            finally {
                HscUtil._closeCIMClient(cIMClient);
            }
        }
        return null;
    }

    public static void setCIMAttribute(String string, CIMObjectPath cIMObjectPath, String string2, CIMValue cIMValue) throws CIMException {
        CIMClient cIMClient = HscUtil._getCIMClient(string);
        if (cIMClient != null) {
            try {
                cIMClient.setProperty(cIMObjectPath, string2, cIMValue);
            }
            catch (CIMException cIMException) {
                throw new HSCCIMCltException(cIMException);
            }
            finally {
                HscUtil._closeCIMClient(cIMClient);
            }
        }
    }

    public static Enumeration getCIMAssociation(String string, CIMObjectPath cIMObjectPath, String string2, String string3, String string4, String string5) throws CIMException {
        CIMClient cIMClient = HscUtil._getCIMClient(string);
        if (cIMClient != null) {
            try {
                Enumeration enumeration;
                Enumeration enumeration2 = enumeration = cIMClient.associatorNames(cIMObjectPath, string2, string3, string4, string5);
                return enumeration2;
            }
            catch (CIMException cIMException) {
                throw new HSCCIMCltException(cIMException);
            }
            finally {
                HscUtil._closeCIMClient(cIMClient);
            }
        }
        return null;
    }

    public static Enumeration getCIMAssociationInst(String string, CIMObjectPath cIMObjectPath, String string2, String string3, String string4, String string5, boolean bl, boolean bl2, String[] stringArray) throws CIMException {
        CIMClient cIMClient = HscUtil._getCIMClient(string);
        if (cIMClient != null) {
            try {
                Enumeration enumeration = cIMClient.associators(cIMObjectPath, string2, string3, string4, string5, bl, bl2, stringArray);
                Enumeration enumeration2 = HscUtil.handleClassCode(string3, enumeration);
                return enumeration2;
            }
            catch (CIMException cIMException) {
                throw new HSCCIMCltException(cIMException);
            }
            finally {
                HscUtil._closeCIMClient(cIMClient);
            }
        }
        return null;
    }

    public static Enumeration getCIMReferences(String string, CIMObjectPath cIMObjectPath, String string2, String string3) throws CIMException {
        CIMClient cIMClient = HscUtil._getCIMClient(string);
        if (cIMClient != null) {
            try {
                Enumeration enumeration;
                Enumeration enumeration2 = enumeration = cIMClient.referenceNames(cIMObjectPath, string2, string3);
                return enumeration2;
            }
            catch (CIMException cIMException) {
                throw new HSCCIMCltException(cIMException);
            }
            finally {
                HscUtil._closeCIMClient(cIMClient);
            }
        }
        return null;
    }

    public static Enumeration getCIMReferencesInst(String string, CIMObjectPath cIMObjectPath, String string2, String string3, boolean bl, boolean bl2, String[] stringArray) throws CIMException {
        CIMClient cIMClient = HscUtil._getCIMClient(string);
        if (cIMClient != null) {
            try {
                Enumeration enumeration;
                Enumeration enumeration2 = enumeration = cIMClient.references(cIMObjectPath, string2, string3, bl, bl2, stringArray);
                return enumeration2;
            }
            catch (CIMException cIMException) {
                throw new HSCCIMCltException(cIMException);
            }
            finally {
                HscUtil._closeCIMClient(cIMClient);
            }
        }
        return null;
    }

    public static Enumeration getCIMEnumInstances(String string, CIMObjectPath cIMObjectPath, boolean bl) throws CIMException {
        CIMClient cIMClient = HscUtil._getCIMClient(string);
        if (cIMClient != null) {
            try {
                Enumeration enumeration;
                Enumeration enumeration2 = enumeration = cIMClient.enumInstances(cIMObjectPath, bl);
                return enumeration2;
            }
            catch (CIMException cIMException) {
                throw new HSCCIMCltException(cIMException);
            }
            finally {
                HscUtil._closeCIMClient(cIMClient);
            }
        }
        return null;
    }

    public static Enumeration getCIMEnumInstances(String string, CIMObjectPath cIMObjectPath, boolean bl, boolean bl2) throws CIMException {
        Enumeration enumeration = null;
        CIMClient cIMClient = HscUtil._getCIMClient(string);
        if (cIMClient != null) {
            try {
                enumeration = bl ? cIMClient.enumInstances(cIMObjectPath, false, bl2) : cIMClient.enumInstances(cIMObjectPath, true, bl2);
                Enumeration enumeration2 = HscUtil.handleClassCode(cIMObjectPath.getObjectName(), enumeration);
                return enumeration2;
            }
            catch (CIMException cIMException) {
                throw new HSCCIMCltException(cIMException);
            }
            finally {
                HscUtil._closeCIMClient(cIMClient);
            }
        }
        return null;
    }

    public static CIMInstance getCIMInstance(String string, CIMObjectPath cIMObjectPath, boolean bl) throws CIMException {
        CIMClient cIMClient = HscUtil._getCIMClient(string);
        if (cIMClient != null) {
            try {
                CIMInstance cIMInstance = cIMClient.getInstance(cIMObjectPath, bl);
                String string2 = cIMObjectPath.getObjectName();
                if (string2.equalsIgnoreCase("IBMHSC_PCISlot")) {
                    HscUtil.handleSlotClassCode(cIMInstance);
                }
                CIMInstance cIMInstance2 = cIMInstance;
                return cIMInstance2;
            }
            catch (CIMException cIMException) {
                throw new HSCCIMCltException(cIMException);
            }
            finally {
                HscUtil._closeCIMClient(cIMClient);
            }
        }
        return null;
    }

    private static Enumeration handleClassCode(String string, Enumeration enumeration) {
        if (!string.equals("IBMHSC_PCISlot")) {
            return enumeration;
        }
        Vector<CIMInstance> vector = new Vector<CIMInstance>();
        while (enumeration.hasMoreElements()) {
            CIMInstance cIMInstance = (CIMInstance)enumeration.nextElement();
            HscUtil.handleSlotClassCode(cIMInstance);
            vector.addElement(cIMInstance);
        }
        return vector.elements();
    }

    private static void handleSlotClassCode(CIMInstance cIMInstance) {
        CIMProperty cIMProperty = cIMInstance.getProperty("ClassCodeInfo");
        CIMValue cIMValue = cIMProperty.getValue();
        CIMValue cIMValue2 = cIMInstance.getProperty("ClassCode").getValue();
        cIMProperty.setValue(HscUtil.handleSlotClassCode(cIMValue2, cIMValue));
    }

    private static CIMValue handleSlotClassCode(CIMValue cIMValue, CIMValue cIMValue2) {
        String string = null;
        String string2 = null;
        CIMValue cIMValue3 = null;
        cIMValue3 = cIMValue == null || cIMValue2 == null || (string = (String)cIMValue2.getValue()) == null || (string2 = (String)cIMValue.getValue()) == null || string.equals("Empty") ? new CIMValue((Object)HSCResourceBundleUtil.getMessage("ProfileBundle", "EMPTY_SLOT", "Empty")) : new CIMValue((Object)HSCResourceBundleUtil.getMessage("HscPciClassCodeInfo", string2, string));
        return cIMValue3;
    }

    public static CIMClass getCIMClass(String string, CIMObjectPath cIMObjectPath, boolean bl) throws CIMException {
        CIMClient cIMClient = HscUtil._getCIMClient(string);
        if (cIMClient != null) {
            try {
                CIMClass cIMClass;
                CIMClass cIMClass2 = cIMClass = cIMClient.getClass(cIMObjectPath, bl);
                return cIMClass2;
            }
            catch (CIMException cIMException) {
                throw new HSCCIMCltException(cIMException);
            }
            finally {
                HscUtil._closeCIMClient(cIMClient);
            }
        }
        return null;
    }

    public static CIMInstance createNewCIMInstance(CIMClass cIMClass) throws CIMException {
        return cIMClass.newInstance();
    }

    public static CIMObjectPath createCIMInstance(String string, CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
        CIMClient cIMClient = HscUtil._getCIMClient(string);
        if (cIMClient != null) {
            try {
                CIMObjectPath cIMObjectPath2;
                CIMObjectPath cIMObjectPath3 = cIMObjectPath2 = cIMClient.createInstance(cIMObjectPath, cIMInstance);
                return cIMObjectPath3;
            }
            catch (CIMException cIMException) {
                throw new HSCCIMCltException(cIMException);
            }
            finally {
                HscUtil._closeCIMClient(cIMClient);
            }
        }
        return null;
    }

    public static void deleteCIMInstance(String string, CIMObjectPath cIMObjectPath) throws CIMException {
        CIMClient cIMClient = HscUtil._getCIMClient(string);
        if (cIMClient != null) {
            try {
                cIMClient.deleteInstance(cIMObjectPath);
            }
            catch (CIMException cIMException) {
                throw new HSCCIMCltException(cIMException);
            }
            finally {
                HscUtil._closeCIMClient(cIMClient);
            }
        }
    }

    public static void setCIMInstance(String string, CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
        CIMClient cIMClient = HscUtil._getCIMClient(string);
        if (cIMClient != null) {
            try {
                cIMClient.setInstance(cIMObjectPath, cIMInstance);
            }
            catch (CIMException cIMException) {
                throw new HSCCIMCltException(cIMException);
            }
            finally {
                HscUtil._closeCIMClient(cIMClient);
            }
        }
    }

    public static CIMValue invokeCIMMethod(String string, CIMObjectPath cIMObjectPath, String string2, Vector vector, Vector vector2) throws CIMException {
        CIMClient cIMClient = HscUtil._getCIMClient(string);
        if (cIMClient != null) {
            try {
                CIMValue cIMValue = cIMClient.invokeMethod(cIMObjectPath, string2, vector, vector2);
                cIMValue = HscUtil.nlsChkVal(cIMValue);
                if (vector2 != null && vector2.size() > 0) {
                    HscUtil.nlsChkVec(vector2);
                }
                CIMValue cIMValue2 = cIMValue;
                return cIMValue2;
            }
            catch (CIMException cIMException) {
                throw new HSCCIMCltException(cIMException);
            }
            finally {
                HscUtil._closeCIMClient(cIMClient);
            }
        }
        return null;
    }

    private static CIMValue nlsChkVal(CIMValue cIMValue) {
        if (cIMValue == null || cIMValue.isEmpty() || cIMValue.isNullValue()) {
            return cIMValue;
        }
        Object object = cIMValue.getValue();
        if (object == null) {
            return cIMValue;
        }
        if (!cIMValue.isArrayValue() && !(object instanceof String)) {
            return cIMValue;
        }
        if (object instanceof String) {
            return new CIMValue((Object)HSCResourceBundleUtil.decodeNLSMsgs((String)object));
        }
        if (!cIMValue.getType().equals((Object)_strArrayType)) {
            return cIMValue;
        }
        Vector vector = (Vector)object;
        if (vector.size() < 1) {
            return cIMValue;
        }
        for (int i = 0; i < vector.size(); ++i) {
            String string = (String)vector.elementAt(i);
            vector.set(i, HSCResourceBundleUtil.decodeNLSMsgs(string));
        }
        return cIMValue;
    }

    private static void nlsChkVec(Vector vector) {
        if (vector == null || vector.size() < 1) {
            return;
        }
        for (int i = 0; i < vector.size(); ++i) {
            CIMValue cIMValue;
            Object e = vector.elementAt(i);
            if (e == null) continue;
            if (e instanceof CIMValue) {
                cIMValue = HscUtil.nlsChkVal((CIMValue)e);
                if (cIMValue == e) continue;
                vector.set(i, cIMValue);
                continue;
            }
            cIMValue = HscUtil.nlsChkVal(((CIMProperty)e).getValue());
            ((CIMProperty)e).setValue(cIMValue);
        }
    }

    public static CIMClient openCIMClient(String string) {
        return HscUtil._getCIMClient(string);
    }

    private static CIMClient _getCIMClient(String string) {
        CIMClient cIMClient = null;
        try {
            CIMNameSpace cIMNameSpace = new CIMNameSpace(string, NAME_SPACE);
            switch (s_utilOwner) {
                case 1: {
                    WSession wSession = WSessionMgr.getSessionMgr().getSession(string);
                    if (wSession != null) {
                        WRemoteSystem wRemoteSystem = wSession.getRemoteSystem();
                        EAuthorization eAuthorization = wRemoteSystem.getAuthorization();
                        s_uname = eAuthorization.getName();
                    }
                    if (s_uname == null) {
                        s_uname = "unknownuser";
                    } else {
                        s_magickey = AcaUtils.getPwdkeyByName((String)s_uname);
                    }
                    s_utilOwner = 2;
                    cIMClient = new CIMClient(cIMNameSpace, s_uname, s_magickey);
                    break;
                }
                case 2: 
                case 3: 
                case 5: {
                    cIMClient = new CIMClient(cIMNameSpace, s_uname, s_magickey);
                    break;
                }
                case 4: {
                    UserInfo userInfo = UserInfo.getUser();
                    if (userInfo == null) {
                        return null;
                    }
                    cIMClient = new CIMClient(cIMNameSpace, userInfo.getUserName(), userInfo.getLoginKey());
                    break;
                }
                default: {
                    System.out.println("Something Wrong, still use hscroot!");
                    String string2 = HscPasswordMgr.getHscUser();
                    cIMClient = new CIMClient(cIMNameSpace, string2, HscPasswordMgr.getCredentialKey(string2));
                    break;
                }
            }
        }
        catch (Throwable throwable) {
            if (_debug) {
                System.out.println("CIM Exception in _getCIMClient: " + throwable);
                throwable.printStackTrace();
            }
            return null;
        }
        return cIMClient;
    }

    private static void _closeCIMClient(CIMClient cIMClient) {
        block3: {
            if (cIMClient != null) {
                try {
                    cIMClient.close();
                }
                catch (Exception exception) {
                    if (!_debug) break block3;
                    exception.printStackTrace();
                }
            }
        }
    }

    public static CIMObjectPath constructPath(CIMInstance cIMInstance) {
        Vector vector = cIMInstance.getKeyValuePairs();
        CIMObjectPath cIMObjectPath = new CIMObjectPath(cIMInstance.getClassName(), NAME_SPACE);
        cIMObjectPath.setKeys(vector);
        return cIMObjectPath;
    }

    public static void subscribeForCIMEvent(String string) {
        if (subscription == null) {
            HscUtil._setEventNotification(string);
        }
    }

    private static void _setEventNotification(String string) {
        block19: {
            HSCCltEventQueue hSCCltEventQueue;
            String string2;
            String string3;
            block18: {
                block17: {
                    block16: {
                        block15: {
                            int n;
                            int n2;
                            string3 = HscPasswordMgr.getHscUser();
                            string2 = HscPasswordMgr.getCredentialKey(string3);
                            hSCCltEventQueue = null;
                            try {
                                HscCimomListener hscCimomListener;
                                if (_debug) {
                                    System.out.println("In _setEventNotification");
                                }
                                if (_eventCimClient == null) {
                                    hscCimomListener = new CIMNameSpace(string, NAME_SPACE);
                                    _eventCimClient = new CIMClient((CIMNameSpace)hscCimomListener, string3, string2);
                                }
                                hscCimomListener = new HscCimomListener();
                                hSCCltEventQueue = new HSCCltEventQueue(hscCimomListener);
                                subscription = HSCSubscriptionMgrFactory.createSubscriptionMgr(string, null, -1, true, -1, null, hscCimomListener);
                                hscCimomListener.setSubscriptionMgr(subscription);
                                hscCimomListener.setEventQueue(hSCCltEventQueue);
                                hscCimomListener.start();
                            }
                            catch (Throwable throwable) {
                                subscription = null;
                                if (_debug) {
                                    throwable.printStackTrace();
                                }
                                return;
                            }
                            int n3 = n2 = 127;
                            int n4 = n = 7;
                            int n5 = n;
                            try {
                                subscription.subscribe(1, "IBMHSC_ComputerSystem", string3, string2, hSCCltEventQueue);
                                subscription.subscribe(2, "IBMHSC_ComputerSystem", string3, string2, hSCCltEventQueue);
                                subscription.subscribe(4, "IBMHSC_ComputerSystem", string3, string2, hSCCltEventQueue);
                                subscription.subscribe(8, "IBMHSC_ComputerSystem", string3, string2, hSCCltEventQueue);
                                subscription.subscribe(16, "IBMHSC_ComputerSystem", string3, string2, hSCCltEventQueue);
                                subscription.subscribe(32, "IBMHSC_ComputerSystem", string3, string2, hSCCltEventQueue);
                                subscription.subscribe(64, "IBMHSC_ComputerSystem", string3, string2, hSCCltEventQueue);
                                subscription.subscribe(80, "IBMHSC_ComputerSystem", string3, string2, hSCCltEventQueue);
                            }
                            catch (Throwable throwable) {
                                if (!_debug) break block15;
                                throwable.printStackTrace();
                            }
                        }
                        try {
                            subscription.subscribe(1, "IBMHSC_Partition", string3, string2, hSCCltEventQueue);
                            subscription.subscribe(2, "IBMHSC_Partition", string3, string2, hSCCltEventQueue);
                            subscription.subscribe(4, "IBMHSC_Partition", string3, string2, hSCCltEventQueue);
                            subscription.subscribe(8, "IBMHSC_Partition", string3, string2, hSCCltEventQueue);
                            subscription.subscribe(16, "IBMHSC_Partition", string3, string2, hSCCltEventQueue);
                        }
                        catch (Throwable throwable) {
                            if (!_debug) break block16;
                            throwable.printStackTrace();
                        }
                    }
                    try {
                        subscription.subscribe(1, "IBMHSC_LparProfile", string3, string2, hSCCltEventQueue);
                        subscription.subscribe(2, "IBMHSC_LparProfile", string3, string2, hSCCltEventQueue);
                        subscription.subscribe(4, "IBMHSC_LparProfile", string3, string2, hSCCltEventQueue);
                    }
                    catch (Throwable throwable) {
                        if (!_debug) break block17;
                        throwable.printStackTrace();
                    }
                }
                try {
                    subscription.subscribe(1, "IBMHSC_SystemProfile", string3, string2, hSCCltEventQueue);
                    subscription.subscribe(2, "IBMHSC_SystemProfile", string3, string2, hSCCltEventQueue);
                    subscription.subscribe(4, "IBMHSC_SystemProfile", string3, string2, hSCCltEventQueue);
                }
                catch (Throwable throwable) {
                    if (!_debug) break block18;
                    throwable.printStackTrace();
                }
            }
            try {
                subscription.subscribe(1, "IBMHSC_Frame", string3, string2, hSCCltEventQueue);
                subscription.subscribe(2, "IBMHSC_Frame", string3, string2, hSCCltEventQueue);
                subscription.subscribe(4, "IBMHSC_Frame", string3, string2, hSCCltEventQueue);
                subscription.subscribe(1, "IBMHSC_FrameCompSys", string3, string2, hSCCltEventQueue);
                subscription.subscribe(2, "IBMHSC_FrameCompSys", string3, string2, hSCCltEventQueue);
                subscription.subscribe(-1, null, string3, string2, hSCCltEventQueue);
                subscription.subscribe(-2, null, string3, string2, hSCCltEventQueue);
            }
            catch (Throwable throwable) {
                if (!_debug) break block19;
                throwable.printStackTrace();
            }
        }
    }

    public static CIMValue getCIMAttribute(CIMInstance cIMInstance, String string) throws CIMException {
        return cIMInstance.getProperty(string).getValue();
    }

    public static boolean isOnOffCapable(String string, CIMObjectPath cIMObjectPath) {
        block3: {
            try {
                CIMProperty cIMProperty;
                int n;
                CIMInstance cIMInstance = HscUtil.getCIMInstance(string, cIMObjectPath, false);
                if (cIMInstance != null && ((n = ((UnsignedInt16)(cIMProperty = cIMInstance.getProperty("CUoDCapabilities")).getValue().getValue()).intValue()) & 0x80) == 128) {
                    return true;
                }
            }
            catch (CIMException cIMException) {
                if (!IDebug.enabled) break block3;
                cIMException.printStackTrace();
            }
        }
        return false;
    }

    static {
        s_utilOwner = 1;
        _strArrayType = new CIMDataType(29);
        subscription = null;
        _eventCimClient = null;
        _debug = false;
    }
}

